/****** Object:  UserDefinedFunction [dbo].[UFD_SINTEGRA_REG_54]    Script Date: 10/31/2013 16:04:53 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_SINTEGRA_REG_54]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_SINTEGRA_REG_54]
GO
GO
CREATE FUNCTION [dbo].[UFD_SINTEGRA_REG_54] (  
            @CD_EMP INT,  
            @CD_FILIAL VARCHAR(max),  
            @DT_INI DATETIME,  
            @DT_FIM DATETIME)  
 -- Versao 2599            
RETURNS @RS_NF_SINTEGRA TABLE  (  
       CD_EMP      INT,  
       CD_FILIAL     INT,  
       CD_NF      INT,  
       CGC_CPF      VARCHAR(20),   
       INSC_EST     VARCHAR(20),   
       SERIE_NF     VARCHAR(10),   
       NR_NF      INT,   
       CD_PROD      MONEY,   
       QT_IT      MONEY,   
       CFOP      VARCHAR(15),   
       VLR_TOT_IT     MONEY,   
       VLR_ICMS_BASE    MONEY,   
       VLR_ICMS     MONEY,   
       ALIQ_ICMS     MONEY,   
       VLR_BASE_SUBS    MONEY,   
         VLR_ICMS_SUBS    MONEY,   
       VLR_IPI      MONEY,   
       VLR_DESC_IT     MONEY,  
       CD_TRIB_FC     VARCHAR(10),  
       TP_TRANSA     INT,  
       TP_SR_NFE                   INT,
       MODELO			VARCHAR(10) ,
       TRIB_FC_ELETRONICO varchar(4) ,
	   ICMS_DESONERADO   MONEY )
AS  
BEGIN  
DECLARE @RS_NF_PROD TABLE(   
       CD_EMP      INT,  
       CD_FILIAL     INT,  
       CD_NF      INT,  
       CGC_CPF      VARCHAR(20),   
       INSC_EST     VARCHAR(20),   
       SERIE_NF     VARCHAR(10),   
       NR_NF      INT,   
       CD_PROD      MONEY,   
       QT_IT       MONEY,   
       CFOP      VARCHAR(15),   
       VLR_TOT_IT     MONEY,   
       VLR_ICMS_BASE    MONEY,   
       VLR_ICMS     MONEY,   
       ALIQ_ICMS     MONEY,   
       VLR_BASE_SUBS    MONEY,   
          VLR_ICMS_SUBS    MONEY,   
       VLR_IPI      MONEY,  
       VLR_DESC_IT     MONEY,   
       CD_TRIB_FC     VARCHAR(10),  
       TP_TRANSA     INT,  
       TP_SR_NFE                   INT,
       MODELO		VARCHAR(10),
       TRIB_FC_ELETRONICO varchar(4),
	   VLR_ICMS_DESONERADO	  MONEY)
 

  
INSERT INTO @RS_NF_PROD  

 SELECT       
  V_EST_NF_SAI_SINTEGRA.CD_EMP,  
  V_EST_NF_SAI_SINTEGRA.CD_FILIAL,  
  V_EST_NF_SAI_SINTEGRA.CD_NF,  
  V_EST_NF_SAI_SINTEGRA.CGC_CPF,   
  V_EST_NF_SAI_SINTEGRA.INSC_EST,   
  LEFT(V_EST_NF_SAI_SINTEGRA.SERIE_NF,3) AS SERIE_NF,   
  V_EST_NF_SAI_SINTEGRA.NR_NF,   
  V_EST_NF_SAI_SINTEGRA.CD_PROD,   
  V_EST_NF_SAI_SINTEGRA.QT_IT,  
  V_EST_NF_SAI_SINTEGRA.CFOP,   
  CASE WHEN PDV_VD_EST_NF_SAI.CD_NF IS NULL THEN 
	VLR_TOT_IT
  ELSE	
	0
  END VLR_TOT_IT,   
  CASE WHEN PDV_VD_EST_NF_SAI.CD_NF IS NULL THEN 
	VLR_ICMS_BASE
  ELSE	
	0
  END VLR_ICMS_BASE,   
  CASE WHEN PDV_VD_EST_NF_SAI.CD_NF IS NULL THEN 
	VLR_ICMS
  ELSE	
	0
  END VLR_ICMS,   

  CASE WHEN PDV_VD_EST_NF_SAI.CD_NF IS NULL THEN 
	ALIQ_ICMS
  ELSE	
	0
  END ALIQ_ICMS,   
  CASE WHEN PDV_VD_EST_NF_SAI.CD_NF IS NULL THEN 
	VLR_BASE_SUBS
  ELSE	
	0
  END VLR_BASE_SUBS,   

  CASE WHEN PDV_VD_EST_NF_SAI.CD_NF IS NULL THEN 
	VLR_ICMS_SUBS
  ELSE	
	0
  END VLR_ICMS_SUBS,   

  CASE WHEN PDV_VD_EST_NF_SAI.CD_NF IS NULL THEN 
	VLR_IPI
  ELSE	
	0
  END VLR_IPI,   

  CASE WHEN PDV_VD_EST_NF_SAI.CD_NF IS NULL THEN 
	VLR_DESC_IT
  ELSE	
	0
  END VLR_DESC_IT,   
  CD_TRIB_FC,  
  0,  
  TP_SR_NFE,
  COD_MODELO,
  '' as TRIB_FC_ELETRONICO,
  ISNULL(V_EST_NF_SAI_SINTEGRA.VLR_ICMS_DESONERADO,0)  as VLR_ICMS_DESONERADO
 FROM           
  V_EST_NF_SAI_SINTEGRA LEFT OUTER JOIN PDV_VD_EST_NF_SAI ON  
  V_EST_NF_SAI_SINTEGRA.CD_EMP = PDV_VD_EST_NF_SAI.CD_EMP AND  
  V_EST_NF_SAI_SINTEGRA.CD_FILIAL = PDV_VD_EST_NF_SAI.CD_FILIAL AND  
  V_EST_NF_SAI_SINTEGRA.CD_NF = PDV_VD_EST_NF_SAI.CD_NF   
 
 WHERE       
  
  V_EST_NF_SAI_SINTEGRA.CD_EMP = @CD_EMP   
  AND V_EST_NF_SAI_SINTEGRA.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL))   
  AND V_EST_NF_SAI_SINTEGRA.DT_EMI_NF BETWEEN @DT_INI AND @DT_FIM  
  
INSERT INTO @RS_NF_PROD  
 SELECT       
  CD_EMP,  
  CD_FILIAL,  
  CD_NF,  
  CGC_CPF,   
  INSC_EST,   
  LEFT(SERIE_NF,3) AS SERIE_NF,   
  NR_NF,   
  CD_PROD,   
  QT_IT,   
  CFOP,   
  VLR_TOT_IT, 
    
  CASE WHEN FLAG_MICRO_EMPRESA= 0 THEN 
	VLR_ICMS_BASE
  ELSE
  0
  END VLR_ICMS_BASE, 
  
  CASE WHEN FLAG_MICRO_EMPRESA= 0 THEN  
  VLR_ICMS
  ELSE
  0
  END VLR_ICMS, 
  
  CASE WHEN FLAG_MICRO_EMPRESA= 0 THEN  
  ALIQ_ICMS
  ELSE
  0
  END ALIQ_ICMS,   
  VLR_BASE_SUBS,   
  VLR_ICMS_SUBS,   
  VLR_IPI,   
  VLR_DESC,  
  CD_TRIB_FC,  
  1,  
  TP_SR_NFE,
  COD_MODELO,
  TRIB_FC_ELETRONICO,
  ISNULL(VLR_ICMS_DESONERADO,0) AS VLR_ICMS_DESONERADO
 FROM           
  V_EST_NF_ENT_SINTEGRA  

 WHERE       
  CD_EMP = @CD_EMP   
  AND CD_FILIAL  IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL))
  AND DT_ENT BETWEEN @DT_INI AND @DT_FIM  
  
INSERT INTO @RS_NF_SINTEGRA SELECT * FROM @RS_NF_PROD   
RETURN  
END  